#Created by Alpha Pixel
#www.AlphaPixel.net
#Updated 8-13-18

import c4d, os
from c4d import gui,documents


def main():
    
    docPath = doc.GetDocumentPath()
    docName = doc.GetDocumentName()
    scenePath = docPath + "//" + docName
    
    br = c4d.documents.GetBatchRender()
    brCount = br.GetElementCount()
    
    rdata = doc.GetActiveRenderData()
    filePath = rdata[c4d.RDATA_PATH]


    RenderFileName = filePath.rsplit("/" , 1)[-1] 
    if RenderFileName[-4] == ".": 
        RenderFileName = RenderFileName[:-4]
    if RenderFileName[-1] == "_": 
        RenderFileName = RenderFileName[:-1]

    docName = doc.GetDocumentName()
    folderPath = filePath.rsplit("/" , 1)[0] + "/" + "Render_Scene" + "/"

    filePath = folderPath + RenderFileName + ".c4d"
    
    if not os.path.exists(folderPath):
        os.makedirs(folderPath)

    br.Open()
    br.AddFile(scenePath,brCount)

    documents.SaveDocument(doc, filePath, c4d.SAVEDOCUMENTFLAGS_DONTADDTORECENTLIST, c4d.FORMAT_C4DEXPORT)
    

if __name__=='__main__':
    main()
